/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.attachment.storage;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.attachment.Context;
import de.willuhn.jameica.attachment.storage.StorageProvider;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.ArchiveService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class StorageProviderMessagingService
implements StorageProvider {
    private static final I18N i18n = Application.getI18n();
    @Resource
    private ArchiveService archiveService = null;

    @Override
    public String getId() {
        return "jameica.messaging";
    }

    @Override
    public boolean isEnabled() {
        return this.archiveService.isEnabled();
    }

    @Override
    public String getName() {
        return i18n.tr("Jameica Messaging");
    }

    @Override
    public List<Attachment> getAttachments(Context ctx) throws IOException {
        LinkedList<Attachment> result = new LinkedList<Attachment>();
        if (ctx == null) {
            return result;
        }
        String channel = this.getChannel(ctx);
        QueryMessage ml = new QueryMessage(channel, null);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.list").sendSyncMessage(ml);
        List uuids = (List)ml.getData();
        if (uuids == null || uuids.isEmpty()) {
            return result;
        }
        for (String uuid : uuids) {
            QueryMessage mm = new QueryMessage(uuid, null);
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.getmeta").sendSyncMessage(mm);
            Map meta = (Map)mm.getData();
            if (meta == null || meta.isEmpty()) {
                Logger.warn((String)("no meta-data found for attachment uuid " + uuid));
                continue;
            }
            Attachment a = new Attachment();
            a.setStorageId(this.getId());
            a.setContext(ctx);
            a.setUuid(uuid);
            a.setFilename((String)meta.get("filename"));
            a.setDate(meta.get("date") != null ? Long.parseLong((String)meta.get("date")) : 0L);
            if (a.getFilename() == null) {
                Logger.warn((String)("invalid message for UUID " + uuid + " - missing filename"));
                continue;
            }
            result.add(a);
        }
        return result;
    }

    @Override
    public void create(Attachment a, InputStream is) throws IOException {
        Logger.info((String)("creating new attachment file " + a.getFilename()));
        String channel = this.getChannel(a.getContext());
        QueryMessage m = new QueryMessage(channel, is);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.put").sendSyncMessage(m);
        String uuid = m.getData().toString();
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("filename", a.getFilename());
        meta.put("date", Long.toString(System.currentTimeMillis()));
        QueryMessage mm = new QueryMessage(uuid, meta);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.putmeta").sendSyncMessage(mm);
        a.setUuid(uuid);
    }

    @Override
    public void update(Attachment a, InputStream is) throws IOException {
        String uuid = a.getUuid();
        this.create(a, is);
        QueryMessage m = new QueryMessage(uuid, null);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.del").sendSyncMessage(m);
    }

    @Override
    public void copy(Attachment a, OutputStream os) throws IOException {
        QueryMessage m = new QueryMessage(a.getUuid(), null);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.get").sendSyncMessage(m);
        Object data = m.getData();
        if (!(data instanceof byte[])) {
            throw new IOException("attachment not found: " + a.getFilename());
        }
        os.write((byte[])data);
    }

    @Override
    public void delete(Attachment a) throws IOException {
        QueryMessage m = new QueryMessage(a.getUuid(), null);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.del").sendSyncMessage(m);
    }

    private String getChannel(Context ctx) {
        return StringUtils.defaultIfBlank((String)ctx.getPlugin(), (String)"default") + "." + StringUtils.defaultIfBlank((String)ctx.getClassName(), (String)"default") + "." + StringUtils.defaultIfBlank((String)ctx.getId(), (String)"default");
    }
}

